/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.parsing;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.css.core.parsing.CSSTokenType;
import com.aptana.editor.css.parsing.CSSTokenScanner;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;

public class CSSScanner
extends Scanner {
    private CSSTokenScanner fTokenScanner = new CSSTokenScanner();
    private IDocument fDocument;
    private List<IRange> fComments = new ArrayList<IRange>();

    public void setSource(String text) {
        this.setSource((IDocument)new Document(text));
    }

    public void setSource(IDocument document) {
        this.fDocument = document;
        this.fTokenScanner.setRange(this.fDocument, 0, this.fDocument.getLength());
        this.fComments.clear();
    }

    public IRange[] getComments() {
        return this.fComments.toArray(new IRange[this.fComments.size()]);
    }

    public Symbol nextToken() throws IOException, Scanner.Exception {
        int length;
        int offset;
        IToken token = this.fTokenScanner.nextToken();
        Object data = token.getData();
        while (token.isWhitespace() || data != null && data.equals(CSSTokenType.COMMENT)) {
            if (CSSTokenType.COMMENT.equals(data)) {
                offset = this.fTokenScanner.getTokenOffset();
                length = this.fTokenScanner.getTokenLength();
                this.fComments.add((IRange)new Range(offset, offset + length - 1));
            }
            token = this.fTokenScanner.nextToken();
            data = token.getData();
        }
        offset = this.fTokenScanner.getTokenOffset();
        length = this.fTokenScanner.getTokenLength();
        short type = data != null ? ((CSSTokenType)data).getShort() : CSSTokenType.EOF.getShort();
        String text = null;
        try {
            text = this.fDocument.get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new Symbol(type, offset, offset + length - 1, (Object)text);
    }
}

